# E0266: redundant 'await'

```config-for-examples
{
  "globals": {
    "fs": true,
    "tempDir": true,
    "uri": true
  }
}
```

The `await` operator unwraps a `Promise`, giving you the value when the
`Promise` is resolved. Because a `Promise` cannot resolve to another `Promise`,
`await` will never give you a `Promise` object. Therefore, using `await` on the
result of `await` is redundant:

```javascript
await await fs.promises.rmdir(tempDir);

let data = await await fetch(uri).json();
```

To fix this error, delete the redundant `await` operator:

```javascript
await fs.promises.rmdir(tempDir);
```

Alternatively, wrap the inner `await` expression in parentheses:

```javascript
let data = await (await fetch(uri)).json();
```

Introduced in quick-lint-js version 2.8.0.
