# E0260: TypeScript non-null assertion is not allowed on parameters

In TypeScript, `!` after an expression is a *non-null assertion*. It is a syntax
error to write a non-null assertion after a function parameter:

```typescript
// color cannot be null.
function colorToHexCode(color!: string): string {
  switch (color) {
    // ...
  }
}
```

To fix this error, remove the `!` and ensure the parameter's type does not
include `null`:

```typescript
// color cannot be null.
function colorToHexCode(color: string): string {
  switch (color) {
    // ...
  }
}
```

Introduced in quick-lint-js version 2.7.0.
