# E0239: TypeScript assignment-asserted fields are not supported in JavaScript

In TypeScript, `!` after a class field name indicates a *definite assignment
assertion*. It is a syntax error to use a definite assignment assertion on a
class field in JavaScript code:

```javascript
class AccountBuilder {
  name!: string;
  address = null;

  setName(value) {
    this.name = value;
    return this;
  }

  setAddress(value) {
    this.address = value;
    return this;
  }
}
```

To fix this error, remove the `!` after the field name, and remove the field's
type:

```javascript
class AccountBuilder {
  name;
  address = null;

  setName(value) {
    this.name = value;
    return this;
  }

  setAddress(value) {
    this.address = value;
    return this;
  }
}
```

Introduced in quick-lint-js version 2.6.0.
