# E0222: 'private' is not allowed in JavaScript

JavaScript private properties are declared using `#`. It is a syntax error to
write `private` in JavaScript code:

```javascript
class Downloader {
  private downloadCount = 0;

  download() {
    this.downloadImpl();
    this.downloadCount += 1;
  }

  private downloadImpl() {
    // ...
  }
}
```

To fix this error, rename the property with a `#` prefix and remove the
`private` keyword:

```javascript
class Downloader {
  #downloadCount = 0;

  download() {
    this.#downloadImpl();
    this.#downloadCount += 1;
  }

  #downloadImpl() {
    // ...
  }
}
```

Alternatively, make the property public by removing the `private` keyword:

```javascript
class Downloader {
  downloadCount = 0;

  download() {
    this.downloadImpl();
    this.downloadCount += 1;
  }

  downloadImpl() {
    // ...
  }
}
```

Introduced in quick-lint-js version 2.6.0.
