# E0168: "globals" must be an object

In a [quick-lint-js configuration file][], `"globals"` must be an object or
omitted. It is an error if `"globals"` is an array, a boolean, a number, a
string, or `null`:

```quick-lint-js.config
{
    "globals": [
        "ga",
        "google",
        "$"
    ]
}
```

To fix this error, make `"globals"` an object:

```quick-lint-js.config
{
    "globals": {
        "ga": true,
        "google": true,
        "$": true
    }
}
```

[quick-lint-js configuration file]: https://quick-lint-js.com/config/

Introduced in quick-lint-js version 0.4.0.
