# E0108: 'in' disallowed in C-style for loop initializer

```config-for-examples
{
  "globals": {
    "data": true,
    "opts": true,
    "processItem": true
  }
}
```

C-style `for` loops can have a expression the first `;`-separated part. It is an
error for the expression to use the `in` operator without parentheses:

```javascript
for (let i = 'startAtOne' in opts ? 1 : 0;
     i < opts.count;
     ++i) {
  if (!processItem(data[i])) {
    break;
  }
}
```

To fix this error, surround the `in` expression with parentheses:

```javascript
for (let i = ('startAtOne' in opts) ? 1 : 0;
     i < opts.count;
     ++i) {
  if (!processItem(data[i])) {
    break;
  }
}
```

Introduced in quick-lint-js version 0.2.0.
