# E0041: unclosed template

Template literals start with and end with <code>\`</code>.
It is a syntax error to omit the trailing <code>\`</code>.

```javascript-with-errors
// The final ` is escaped by \.
let temp = `c:\temp\`;
```

```javascript-with-errors
let unfinishedThought = `The solution to all of our problems is
```

To fix this error, ensure a backslash (`\`) is not escaping the terminating
<code>\`</code>, or include a terminating <code>\`</code>:

```javascript
let temp = `c:\\temp\\`;

let unfinishedThought = `The solution to all of our problems is`;
```

Introduced in quick-lint-js version 0.2.0.
