# E0005: BigInt literal contains decimal point

`BigInt` literals are number literals with an `n` suffix. These literals must
represent integers and cannot contain a decimal point (`.`).

```javascript
let gallons = 3.50n;
let pennies = 100.00n;
```

To fix this error, make the number literal a `Number` literal by removing the
`n` suffix, or remove the fractional portion of the number:

```javascript
let gallons = 3.50;
let pennies = 100n;
```

Introduced in quick-lint-js version 0.2.0.
