(() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __require = /* @__PURE__ */ ((x) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x, {
    get: (a, b) => (typeof require !== "undefined" ? require : a)[b]
  }) : x)(function(x) {
    if (typeof require !== "undefined")
      return require.apply(this, arguments);
    throw new Error('Dynamic require of "' + x + '" is not supported');
  });
  var __commonJS = (cb, mod) => function __require2() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));

  // wasm/quick-lint-js.js
  var require_quick_lint_js = __commonJS({
    "wasm/quick-lint-js.js"(exports) {
      "use strict";
      var VSCODE_WASM_MODULE_PATH_BROWSER = "dist/quick-lint-js-vscode.wasm";
      var VSCODE_WASM_MODULE_PATH_NODE_JS = "../public/demo/dist/quick-lint-js-vscode.wasm";
      var DocumentLinterDisposed = class extends Error {
      };
      exports.DocumentLinterDisposed = DocumentLinterDisposed;
      async function createProcessFactoryAsync2() {
        if (typeof window === "undefined") {
          let fs = __require("fs");
          let path = __require("path");
          let wasmCode = await fs.promises.readFile(
            path.join(__dirname, VSCODE_WASM_MODULE_PATH_NODE_JS)
          );
          let wasmModule = await WebAssembly.compile(wasmCode);
          return new ProcessFactory(wasmModule);
        } else {
          let wasmModule = await WebAssembly.compileStreaming(
            fetch(VSCODE_WASM_MODULE_PATH_BROWSER)
          );
          return new ProcessFactory(wasmModule);
        }
      }
      exports.createProcessFactoryAsync = createProcessFactoryAsync2;
      var ProcessCrashed = class extends Error {
      };
      exports.ProcessCrashed = ProcessCrashed;
      var ProcessAborted = class extends ProcessCrashed {
      };
      exports.ProcessAborted = ProcessAborted;
      var ProcessCrashedWithUnknownError = class extends ProcessCrashed {
        constructor(originalError) {
          super(originalError.stack);
          this.originalError = originalError;
        }
      };
      exports.ProcessCrashedWithUnknownError = ProcessCrashedWithUnknownError;
      var LongJumpToken = class {
      };
      var LONG_JUMP_TOKEN = new LongJumpToken();
      var tempRet0 = 0;
      var ProcessFactory = class {
        constructor(wasmModule) {
          this._wasmModule = wasmModule;
        }
        async createProcessAsync() {
          let cachedIndirectFunction = null;
          let cachedIndirectFunctionIndex = -1;
          function longjmp(env, value) {
            if (value === 0) {
              value = 1;
            }
            wasmInstance.exports.setThrew(env, value);
            throw LONG_JUMP_TOKEN;
          }
          function invoke(functionIndex, ...args) {
            let func;
            if (functionIndex === cachedIndirectFunctionIndex) {
              func = cachedIndirectFunction;
            } else {
              func = wasmInstance.exports.__indirect_function_table.get(functionIndex);
              cachedIndirectFunction = func;
              cachedIndirectFunctionIndex = functionIndex;
            }
            let oldStackPointer = wasmInstance.exports.stackSave();
            try {
              return func(...args);
            } catch (e) {
              wasmInstance.exports.stackRestore(oldStackPointer);
              if (e === LONG_JUMP_TOKEN) {
                let env = 1;
                wasmInstance.exports.setThrew(
                  env,
                  /*value=*/
                  0
                );
                return 0;
              } else {
                throw e;
              }
            }
          }
          let wasmInstance = await WebAssembly.instantiate(this._wasmModule, {
            env: {
              // Called by setjmp.
              invoke_ii: invoke,
              invoke_iii: invoke,
              invoke_iiii: invoke,
              invoke_iiiii: invoke,
              invoke_v: invoke,
              invoke_vi: invoke,
              invoke_vii: invoke,
              invoke_viii: invoke,
              invoke_viiii: invoke,
              // Called by longjmp. Different names are for different Emscripten
              // versions and configurations.
              _emscripten_throw_longjmp: longjmp,
              emscripten_longjmp: longjmp,
              emscripten_longjmp_jmpbuf: longjmp,
              getTempRet0: () => tempRet0,
              setTempRet0: (temp) => {
                tempRet0 = temp;
              }
            },
            wasi_snapshot_preview1: {
              fd_close: () => {
                throw new Error("Not implemented: fd_close");
              },
              fd_read: () => {
                throw new Error("Not implemented: fd_read");
              },
              fd_seek: () => {
                throw new Error("Not implemented: fd_seek");
              },
              environ_get: (environ, environBuf) => {
                return 0;
              },
              environ_sizes_get: (outEnvironc, outEnvironBufSize) => {
                let heap = wasmInstance.exports.memory.buffer;
                new Uint32Array(heap, outEnvironc)[0] = 0;
                new Uint32Array(heap, outEnvironBufSize)[0] = 0;
                return 0;
              },
              proc_exit: () => {
                throw new ProcessAborted("quick-lint-js process exited");
              },
              fd_write: (fd, iovsData, iovsSize, outWrittenSize) => {
                let heap = wasmInstance.exports.memory.buffer;
                let iovs = new Uint32Array(heap, iovsData, iovsSize * 8);
                let bytesWritten = 0;
                for (let i = 0; i < iovsSize; ++i) {
                  let bufferPointer = iovs[i * 2 + 0];
                  let bufferSize = iovs[i * 2 + 1];
                  let buffer = new Uint8Array(heap, bufferPointer, bufferSize);
                  process.stdout.write(buffer);
                  bytesWritten += buffer.byteLength;
                }
                new Uint32Array(heap, outWrittenSize)[0] = bytesWritten;
                return 0;
              }
            }
          });
          wasmInstance.exports._initialize();
          return new Process(wasmInstance);
        }
      };
      var nextProcessIDForDebugging = 1;
      var Process = class {
        constructor(wasmInstance) {
          this._idForDebugging = nextProcessIDForDebugging++;
          this._wasmInstance = wasmInstance;
          this._crashedException = null;
          let process2 = this;
          function wrap(name) {
            if (!Object.prototype.hasOwnProperty.call(wasmInstance.exports, name)) {
              throw new TypeError(`WASM does not export function: ${name}`);
            }
            let func = wasmInstance.exports[name];
            return (...args) => {
              try {
                exports.maybeInjectFault(process2, name);
                try {
                  return func(...args);
                } catch (e) {
                  throw new ProcessCrashedWithUnknownError(e);
                }
              } catch (e) {
                if (e instanceof ProcessCrashed) {
                  process2._taint(e);
                }
                throw e;
              }
            };
          }
          this._heap = wasmInstance.exports.memory.buffer;
          this._malloc = wrap("malloc");
          this._free = wrap("free");
          this._listLocales = wrap("qljs_list_locales");
          this._webDemoCreateDocument = wrap("qljs_web_demo_create_document");
          this._webDemoDestroyDocument = wrap("qljs_web_demo_destroy_document");
          this._webDemoLint = wrap("qljs_web_demo_lint");
          this._webDemoSetLanguageOptions = wrap(
            "qljs_web_demo_set_language_options"
          );
          this._webDemoSetLocale = wrap("qljs_web_demo_set_locale");
          this._webDemoSetText = wrap("qljs_web_demo_set_text");
          this._webDemoSetConfig = wrap("qljs_web_demo_set_config");
        }
        isTainted() {
          return this._crashedException !== null;
        }
        _taint(exception) {
          this._crashedException = exception;
          function tainted() {
            throw this._crashedException;
          }
          this._wasmInstance = null;
          this._heap = null;
          this._malloc = tainted;
          this._free = tainted;
          this._listLocales = tainted;
          this._webDemoCreateDocument = tainted;
          this._webDemoDestroyDocument = tainted;
          this._webDemoLint = tainted;
          this._webDemoSetLanguageOptions = tainted;
          this._webDemoSetLocale = tainted;
          this._webDemoSetText = tainted;
        }
        toString() {
          return `Process(id=${this._idForDebugging})`;
        }
        async createDocumentForWebDemoAsync() {
          return new DocumentForWebDemo(this);
        }
        listLocales() {
          let localePointerList = new Uint32Array(this._heap, this._listLocales());
          let locales = [];
          for (let i = 0; localePointerList[i] != 0; ++i) {
            locales.push(
              decodeUTF8CString(new Uint8Array(this._heap, localePointerList[i]))
            );
          }
          return locales;
        }
      };
      var DocumentForWebDemo = class {
        constructor(process2) {
          this._process = process2;
          this._wasmDoc = this._process._webDemoCreateDocument();
        }
        setLanguageOptions(languageOptions) {
          this._process._webDemoSetLanguageOptions(this._wasmDoc, languageOptions);
        }
        setLocale(locale) {
          let utf8Locale = encodeUTF8String(locale, this._process);
          try {
            this._process._webDemoSetLocale(this._wasmDoc, utf8Locale.pointer);
          } finally {
            utf8Locale.dispose();
          }
        }
        setText(text) {
          let utf8Text = encodeUTF8String(text, this._process);
          try {
            this._process._webDemoSetText(
              this._wasmDoc,
              utf8Text.pointer,
              utf8Text.byteSize
            );
          } finally {
            utf8Text.dispose();
          }
        }
        lint() {
          let diagnosticsPointer = this._process._webDemoLint(this._wasmDoc);
          return this._parseDiagnostics(diagnosticsPointer);
        }
        setConfig(configDocument) {
          this._process._webDemoSetConfig(this._wasmDoc, configDocument._wasmDoc);
        }
        _parseDiagnostics(diagnosticsPointer) {
          let rawDiagnostics = new Uint8Array(
            this._process._heap,
            diagnosticsPointer
          );
          let rawDiagnosticsU32 = new Uint32Array(
            this._process._heap,
            diagnosticsPointer
          );
          let rawDiagnosticsPtr = new Uint32Array(
            this._process._heap,
            diagnosticsPointer
          );
          let ERROR = {
            message: 0,
            code: 4,
            severity: 3,
            begin_offset: 4,
            end_offset: 5,
            _byte_size: 6 * 4,
            _ptr_size: 6,
            _u32_size: 6
          };
          let diagnostics = [];
          for (let i = 0; ; ++i) {
            let messagePtr = rawDiagnosticsPtr[i * ERROR._ptr_size + ERROR.message];
            if (messagePtr === 0) {
              break;
            }
            diagnostics.push({
              code: decodeUTF8CString(
                rawDiagnostics.subarray(i * ERROR._byte_size + ERROR.code)
              ),
              message: decodeUTF8CString(
                new Uint8Array(this._process._heap, messagePtr)
              ),
              severity: rawDiagnosticsU32[i * ERROR._u32_size + ERROR.severity],
              begin: rawDiagnosticsU32[i * ERROR._u32_size + ERROR.begin_offset],
              end: rawDiagnosticsU32[i * ERROR._u32_size + ERROR.end_offset]
            });
          }
          return diagnostics;
        }
        dispose() {
          this._process._webDemoDestroyDocument(this._wasmDoc);
          this._wasmDoc = null;
        }
      };
      var DiagnosticSeverity = {
        ERROR: 1,
        WARNING: 2
      };
      exports.DiagnosticSeverity = DiagnosticSeverity;
      var LanguageOptions2 = {
        NONE: 0,
        JSX: 1 << 0,
        TYPESCRIPT: 1 << 1,
        CONFIG_JSON: 1 << 2
      };
      exports.LanguageOptions = LanguageOptions2;
      function encodeUTF8String(string, process2) {
        let maxUTF8BytesPerUTF16CodeUnit = Math.ceil(
          Math.max(
            3 / 1,
            // U+0000..U+ffff: 1..3 UTF-8 bytes, 1 UTF-16 code unit
            5 / 2
            // U+10000..: 5 UTF-8 bytes, 2 UTF-16 code units
          )
        );
        let maxSize = string.length * maxUTF8BytesPerUTF16CodeUnit + 1;
        let textUTF8Pointer = process2._malloc(maxSize);
        try {
          let encoder = new TextEncoder();
          let textUTF8Size;
          let u8Array = new Uint8Array(process2._heap, textUTF8Pointer, maxSize);
          if (typeof encoder.encodeInto === "function") {
            let encodeResult = encoder.encodeInto(string, u8Array);
            if (encodeResult.read !== string.length) {
              throw new Error(
                `Assertion failure: expected encodeResult.read (${encodeResult.read}) to equal string.length (${string.length})`
              );
            }
            textUTF8Size = encodeResult.written;
          } else {
            let encoded = encoder.encode(string);
            u8Array.set(encoded);
            textUTF8Size = encoded.length;
          }
          u8Array[textUTF8Size] = 0;
          return {
            pointer: textUTF8Pointer,
            byteSize: textUTF8Size,
            dispose
          };
        } catch (e) {
          dispose();
          throw e;
        }
        function dispose() {
          process2._free(textUTF8Pointer);
        }
      }
      function decodeUTF8CString(bytes) {
        let nullTerminatorIndex = bytes.indexOf(0);
        if (nullTerminatorIndex < 0) {
          throw new Error("null terminator not found in C string");
        }
        return new TextDecoder().decode(bytes.subarray(0, nullTerminatorIndex));
      }
      exports.maybeInjectFault = (_process, _functionName) => {
      };
    }
  });

  // public/demo/demo.mjs
  var import_quick_lint_js = __toESM(require_quick_lint_js(), 1);

  // public/error-box.mjs
  function showErrorMessageBox(mark, posCursorX, diagnostics) {
    const div = createErrorBox(mark, posCursorX, diagnostics);
    let body = document.querySelector("body");
    body.appendChild(div);
  }
  function createErrorBox(markedElement, posCursorX, diagnostics) {
    let div = document.createElement("div");
    const { bottom } = markedElement.getBoundingClientRect();
    div.setAttribute("id", "error-box");
    div.innerText = diagnostics.map((d) => formatDiagnostic(d)).join("\n");
    div.style.position = "fixed";
    div.style.overflow = "auto";
    div.style.top = `${Math.trunc(bottom)}px`;
    div.style.left = `${posCursorX}px`;
    return div;
  }
  function removeErrorMessageBox() {
    let errorBoxElement = document.querySelector("#error-box");
    if (errorBoxElement !== null) {
      errorBoxElement.remove();
    }
  }
  function showErrorMessage(event, markedElement) {
    removeErrorMessageBox();
    const marks = markedElement.querySelectorAll("mark[data-message]");
    let diagnostics = [];
    let hoveredMarkElement = null;
    for (let mark of marks) {
      if (hasPlayingAnimation(mark)) {
        continue;
      }
      const markRect = mark.getBoundingClientRect();
      if (cursorOverMark(event.clientX, event.clientY, markRect)) {
        diagnostics.push(getDiagnosticFromMark(mark));
        hoveredMarkElement = mark;
      }
    }
    if (hoveredMarkElement !== null) {
      showErrorMessageBox(hoveredMarkElement, event.clientX, diagnostics);
    }
  }
  function hasPlayingAnimation(element) {
    if (typeof element.getAnimations !== "function") {
      return false;
    }
    return element.getAnimations().some((animation) => animation.playState === "running");
  }
  function cursorOverMark(cursorPosX, cursorPosY, markRect) {
    const topDownIn = markRect.bottom >= cursorPosY && cursorPosY >= markRect.top;
    const leftRightIn = cursorPosX >= markRect.left && cursorPosX <= markRect.left + markRect.width;
    return topDownIn && leftRightIn;
  }
  function formatDiagnostic(diagnostic) {
    return diagnostic.code ? `${diagnostic.code} - ${diagnostic.message}` : diagnostic.message;
  }
  function getDiagnosticFromMark(markElement) {
    return {
      message: markElement.attributes["data-message"].value,
      code: markElement.attributes["data-code"]?.value,
      severity: markElement.attributes["data-severity"].value
    };
  }
  function blessErrorMarksWithTooltip(hoveredElement, markedElement) {
    hoveredElement.addEventListener("mousemove", (event) => {
      showErrorMessage(event, markedElement);
    });
    hoveredElement.addEventListener("input", removeErrorMessageBox);
    hoveredElement.addEventListener("click", removeErrorMessageBox);
    hoveredElement.addEventListener("mouseout", removeErrorMessageBox);
  }
  document.addEventListener("DOMContentLoaded", () => {
    const codeInput = document.querySelector("#code-input");
    const codeInputMarks = document.querySelector("#code-input-marks");
    if (codeInput !== null && codeInputMarks !== null) {
      blessErrorMarksWithTooltip(codeInput, codeInputMarks);
    }
    for (let codeBlock of document.querySelectorAll("pre > code.javascript")) {
      blessErrorMarksWithTooltip(codeBlock, codeBlock);
    }
  });

  // public/demo/demo.mjs
  var codeInputElement = document.getElementById("code-input");
  var codeInputMarksElement = document.getElementById("code-input-marks");
  var codeInputMarksScrollerElement = document.getElementById(
    "code-input-marks-scroller"
  );
  var shadowCodeInputElement = document.getElementById("shadow-code-input");
  var enableJSXElement = document.getElementById("enable-jsx");
  var enableTypeScriptElement = document.getElementById("enable-typescript");
  codeInputElement.addEventListener("scroll", (event) => {
    synchronizeScrollingAndSize();
  });
  synchronizeContent();
  synchronizeScrollingAndSize();
  if (typeof window.ResizeObserver !== "undefined") {
    new window.ResizeObserver(synchronizeScrollingAndSize).observe(
      codeInputElement
    );
  }
  var FloatingEditorMarker = class {
    constructor(editorElement, marksContainerElement) {
      this._markWrapperElements = [];
      this._editorElement = editorElement;
      this._marksContainerElement = marksContainerElement;
    }
    setMarks(marks, text) {
      let textNode = this._editorElement.childNodes[0];
      if (typeof textNode === "undefined") {
        return;
      }
      let editorRect = this._editorElement.getBoundingClientRect();
      let offsetX = -editorRect.left + this._editorElement.scrollLeft;
      let offsetY = -editorRect.top + this._editorElement.scrollTop;
      let range = window.document.createRange();
      let markElementIndex = 0;
      for (let i = marks.length; i-- > 0; ) {
        let mark = marks[i];
        range.setStart(textNode, mark.begin);
        range.setEnd(textNode, mark.end);
        let rects = range.getClientRects();
        for (let r of rects) {
          if (r.width === 0 && rects.length > 1) {
            continue;
          }
          let { markElement, markWrapperElement } = this._getOrCreateMarkAndWrapper(markElementIndex++);
          markWrapperElement.style.display = "";
          markWrapperElement.style.left = `${r.left + offsetX}px`;
          markWrapperElement.style.top = `${Math.ceil(r.top + offsetY) + 1}px`;
          markWrapperElement.style.width = `${r.width}px`;
          markWrapperElement.style.height = `${r.height}px`;
          markElement.setAttribute("data-message", mark.message);
          markElement.setAttribute("data-code", mark.code);
          markElement.setAttribute("data-severity", mark.severity);
          markElement.textContent = text.slice(mark.begin, mark.end);
        }
      }
      for (let i = markElementIndex; i < this._markWrapperElements.length; ++i) {
        this._markWrapperElements[i].style.display = "none";
      }
    }
    _getOrCreateMarkAndWrapper(markElementIndex) {
      if (markElementIndex >= this._markWrapperElements.length) {
        return this._createMarkAndWrapper();
      }
      let markWrapperElement = this._markWrapperElements[markElementIndex];
      return {
        markElement: markWrapperElement.firstChild,
        markWrapperElement
      };
    }
    // Create <div class="floating-mark><mark></mark></div>.
    //
    // The inner <mark> is shown visually.
    //
    // The outer .floating-mark <div> is for positioning.
    //
    // If we position the <mark> without a <div> wrapper, the mark underlines get
    // out of alignment. I don't know why.
    _createMarkAndWrapper() {
      let markElement = document.createElement("mark");
      let markWrapperElement = document.createElement("div");
      markWrapperElement.appendChild(markElement);
      markWrapperElement.classList.add("floating-mark");
      this._marksContainerElement.appendChild(markWrapperElement);
      this._markWrapperElements.push(markWrapperElement);
      return { markElement, markWrapperElement };
    }
  };
  (0, import_quick_lint_js.createProcessFactoryAsync)().then(async (processFactory) => {
    async function createDocumentAsync() {
      let process2 = await processFactory.createProcessAsync();
      let doc2 = await process2.createDocumentForWebDemoAsync();
      return doc2;
    }
    let pendingDocument = null;
    let doc = null;
    function processCrashed() {
      doc = null;
      pendingDocument = null;
    }
    function restartProcessThenLint() {
      doc = null;
      pendingDocument = createDocumentAsync().then((newDoc) => {
        doc = newDoc;
        pendingDocument = null;
        lintAndUpdate();
      });
    }
    let marker = new FloatingEditorMarker(
      shadowCodeInputElement,
      codeInputMarksElement
    );
    function lintAndUpdate() {
      if (doc === null) {
        restartProcessThenLint();
        return;
      }
      synchronizeContent();
      let input = codeInputElement.value;
      let marks;
      try {
        doc.setLanguageOptions(
          (enableTypeScriptElement.checked ? import_quick_lint_js.LanguageOptions.TYPESCRIPT : 0) | (enableJSXElement.checked ? import_quick_lint_js.LanguageOptions.JSX : 0)
        );
        doc.setText(input);
        marks = doc.lint();
      } catch (e) {
        marks = [];
        processCrashed();
      }
      marker.setMarks(marks, input);
    }
    codeInputElement.addEventListener("input", (event) => {
      lintAndUpdate();
      synchronizeScrollingAndSize();
    });
    enableTypeScriptElement.addEventListener("change", (_event) => {
      lintAndUpdate();
    });
    enableJSXElement.addEventListener("change", (_event) => {
      lintAndUpdate();
    });
    lintAndUpdate();
  }).catch((error) => {
    console.error(error);
  });
  function synchronizeContent() {
    let input = codeInputElement.value;
    shadowCodeInputElement.textContent = input + "\n\n\n";
  }
  function synchronizeScrollingAndSize() {
    codeInputMarksScrollerElement.style.width = `${codeInputElement.clientWidth}px`;
    codeInputMarksScrollerElement.style.height = `${codeInputElement.clientHeight}px`;
    codeInputMarksElement.style.width = `${codeInputElement.scrollWidth}px`;
    codeInputMarksElement.style.height = `${codeInputElement.scrollHeight}px`;
    let inputScrollTop = codeInputElement.scrollTop;
    let inputScrollLeft = codeInputElement.scrollLeft;
    codeInputMarksScrollerElement.scroll({
      top: inputScrollTop,
      left: inputScrollLeft,
      behavior: "instant"
    });
    let scrollerScrollTop = codeInputMarksScrollerElement.scrollTop;
    let scrollerScrollLeft = codeInputMarksScrollerElement.scrollLeft;
    if (!(scrollerScrollTop === inputScrollTop && scrollerScrollLeft === inputScrollLeft)) {
      console.warn(
        "scrolling out of sync; tried to scroll to <%d,%d> but instead scrolled to <%d,%d>",
        inputScrollLeft,
        inputScrollTop,
        scrollerScrollLeft,
        scrollerScrollTop
      );
    }
  }
})();
