// Copyright (C) 2020  Matthew "strager" Glazar
// See end of file for extended copyright information.

#include <gmock/gmock.h>
#include <gtest/gtest.h>
#include <quick-lint-js/array.h>
#include <quick-lint-js/cli/cli-location.h>
#include <quick-lint-js/container/padded-string.h>
#include <quick-lint-js/diag-matcher.h>
#include <quick-lint-js/diag/diagnostic-types.h>
#include <quick-lint-js/dirty-set.h>
#include <quick-lint-js/fe/language.h>
#include <quick-lint-js/fe/parse.h>
#include <quick-lint-js/parse-support.h>
#include <quick-lint-js/port/char8.h>
#include <quick-lint-js/spy-visitor.h>
#include <string>
#include <string_view>
#include <vector>

using ::testing::ElementsAreArray;

namespace quick_lint_js {
namespace {
class Test_Parse_TypeScript_Ambiguous : public Test_Parse_Expression {};

TEST_F(Test_Parse_TypeScript_Ambiguous, use_generic_variable_named_async) {
  {
    Spy_Visitor p = test_parse_and_visit_statement(u8"async<T>();"_sv, no_diags,
                                                   typescript_options);
    EXPECT_THAT(p.visits, ElementsAreArray({
                              "visit_enter_type_scope",   // <
                              "visit_variable_type_use",  // T
                              "visit_exit_type_scope",    // >
                              "visit_variable_use",       // async
                          }));
    EXPECT_THAT(p.variable_uses, ElementsAreArray({u8"T", u8"async"}));
  }

  {
    Spy_Visitor p = test_parse_and_visit_statement(u8"async<T>;"_sv, no_diags,
                                                   typescript_options);
    EXPECT_THAT(p.visits, ElementsAreArray({
                              "visit_enter_type_scope",   // <
                              "visit_variable_type_use",  // T
                              "visit_exit_type_scope",    // >
                              "visit_variable_use",       // async
                          }));
    EXPECT_THAT(p.variable_uses, ElementsAreArray({u8"T", u8"async"}));
  }
}

TEST_F(Test_Parse_TypeScript_Ambiguous, async_variable_less_than_expression) {
  {
    Spy_Visitor p = test_parse_and_visit_statement(
        u8"async < someexpr;"_sv, no_diags, typescript_options);
    EXPECT_THAT(p.visits, ElementsAreArray({
                              "visit_variable_use",  // async
                              "visit_variable_use",  // someexpr
                          }));
    EXPECT_THAT(p.variable_uses, ElementsAreArray({u8"async", u8"someexpr"}));
  }
}
}
}

// quick-lint-js finds bugs in JavaScript programs.
// Copyright (C) 2020  Matthew "strager" Glazar
//
// This file is part of quick-lint-js.
//
// quick-lint-js is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// quick-lint-js is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with quick-lint-js.  If not, see <https://www.gnu.org/licenses/>.
