# E0716: unintuitive operator precedence when using & and << or >>

```config-for-examples
{
  "globals": {
    "another_variable": true
  }
}
```

JavaScript's operator precedence can cause confusing situations and bugs when it
comes to bitshifting with a bitwise and.
```js
let a_bitwise_variable = another_variable & 0x1 << 0x2
```
The code above looks like it evaluates `another_variable & 0x1` first,
but it instead evaluates `0x1 << 0x2` first. 
If this is intended behavior, it may be easier to read if you write parentheses:
```js
another_variable & (0x1 << 0x2)
```
Otherwise, to get the order of operations correct, add parentheses around the operands of `&`:
```js
(another_variable & 0x1) << 0x2
```
