# E0715: cannot use multiple `export default` statements in one module

Modules in JavaScript can use two types of exports: default export and named export. While a module
can use multiple named exports, it can only use a single default export.


```javascript
export default function foo() {
  console.log("foo");
}

export default function bar() {
  console.log("bar");
}
```


If you want to export several values from a module, use named exports.


```javascript
function foo(x) {
  console.log("foo");
}

function bar(x) {
  console.log("bar");
}

export { foo, bar };
```
