# E0709: expected variable name after '...'

The spread operator ('...') must precede a variable name.

```javascript
const numbers = () => { return [1, 2, 3, 4] };
const [numberOne, numberTwo, ...] = numbers();
```

To fix this mistake, place the identifier after '...':

```javascript
const numbers = () => { return [1, 2, 3, 4] };
const [numberOne, numberTwo, ...rest] = numbers();
```
