# E0369: nullish coalescing operator does nothing when left operand is never null

When left operand is never null (such as comparisons and string literals), the expression will always resolve to the left operand value

```typescript
let g = "hello" ?? "world";
let f = 4 == 5 ?? true;
```

To fix this warning, remove the nullish coalescing operaror (??) and the right operand.

```typescript
let g = "hello";
let f = 4 == 5;
```
