# E0344: using '===' or '!==' against an empty array literal always produces the same result


Using the strict equality operator against an empty array literal will always return 'false', and using the strict inequality operator will always return 'true'. e.g. the conditions below will always be 'false' and 'true' respectively, no matter what value 'x' holds.

```javascript
let x = [];

// the expression inside the if statement is always 'false'
if (x === []) { 
}

// the expression inside the if statement is always 'true'
if (x !== []) { 
}
```

To fix this particular example, we could compare the length of the array

```javascript
let x = [];

if (x.length === 0) {
}
```


Introduced in quick-lint-js version 2.10.0.
