# E0317: newline is not allowed between 'async' and 'function'

```config-for-examples
{
  "globals": {
    "JSONOptions": true,
    "StreamOptions": true,
    "Stream": true
  }
}
```

Async functions have the `async` keyword followed by the `function` keyword. It
is a syntax error to include a line break in between `async` and `function`:

<!-- TODO(strager): Improve this diagnostic so the example is less contrived. -->

```typescript
function fetch(o: JSONOptions): Promise<object>;
function fetch(o: StreamOptions): Promise<Stream>;
async
function fetch(options): Promise<any> {
  /* ... */
}
```

To fix this error, put `function` on the same line as `async`:

```typescript
function fetch(o: JSONOptions): Promise<object>;
function fetch(o: StreamOptions): Promise<Stream>;
async function fetch(options): Promise<any> {
  /* ... */
}
```

Introduced in quick-lint-js version 2.10.0.
