# E0313: 'readonly' only works with array types and tuple types

```config-for-examples
{
  "globals": {
    "User": true,
    "Player": true,
    "Readonly": true
  }
}
```
<!-- TODO(#696): Remove 'Readonly' variable above. -->

In TypeScript, array types and tuple types can be marked `readonly`, which
prevents methods like `.push` from being called on the array. It is a syntax
error to use `readonly` on something which is not an array or tuple type:

```typescript
function isVerified(user: readonly User) {
  return user.verificationDate !== null;
}

const nudge = (
  players: readonly Player,
  dx: number,
  dy: number,
) => players.map(p => ({...p, /* ... */ }));
```

To fix this error, replace `readonly Type` with `Readonly<Type>`:

```typescript
function isVerified(user: Readonly<User>) {
  return user.verificationDate !== null;
}
```

Alternatively, make the type an array type by adding `[]`:

```typescript
const nudge = (
  players: readonly Player[],
  dx: number,
  dy: number,
) => players.map(p => ({...p, /* ... */ }));
```

Introduced in quick-lint-js version 2.10.0.
