# E0311: missing parentheses around parameter; TypeScript optional parameter requires parentheses

In TypeScript, parameters can be explicitly marked as optional with `?`. It is a
syntax error to write an arrow function with an optional parameter without
parentheses around the parameter list:

```typescript
const error = message? => {
  throw new Error(message);
};
```

To fix this error, write parentheses around the parameter list:

```typescript
const error = (message?) => {
  throw new Error(message);
};
```

Introduced in quick-lint-js version 2.10.0.
