# E0305: 'this' parameters are not allowed in JavaScript

TypeScript allows you to explicitly declare the `this` parameter. It is a syntax
error to declare the `this` parameter in JavaScript code:

```javascript
$("form button").each(function (this, index) {
  console.log(`disabling button #${index}`);
  $(this).disable();
});

$("form button").each((this, index) => {
  console.log(`enabling button #${index}`);
  $(this).enable();
});
```

To fix this error, remove the `this` parameter:

```javascript
$("form button").each(function (index) {
  console.log(`disabling button #${index}`);
  $(this).disable();
});
```

Alternatively, convert the arrow function into a function declared with the
`function` keyword and also remove the `this` parameter:

```javascript
$("form button").each(function (index) {
  console.log(`enabling button #${index}`);
  $(this).enable();
});
```

Introduced in quick-lint-js version 2.10.0.
