# E0304: cannot use '...' on 'this' parameter

```config-for-examples
{
  "globals": {
    "args": true
  }
}
```

TypeScript allows you to explicitly declare the `this` parameter. It is a syntax
error to use `...` (spread) on the `this` parameter:

```typescript
function log(message: string, ...this: unknown[]) {
  console.log(`${new Date}: ${message}`, args);
}
```

To fix this error, rename the parameter to something other than `this`:

```typescript
function log(message: string, ...args: unknown[]) {
  console.log(`${new Date}: ${message}`, args);
}
```

Introduced in quick-lint-js version 2.10.0.
