# E0297: abstract properties are not allowed in interfaces

```config-for-examples
{
  "globals": {
    "LogLevel": true
  }
}
```

TypeScript abstract classes can contain abstract methods and fields. Interface
methods and fields are automatically abstract. It is a syntax error to write
`abstract` for an interface method or field:

```typescript
interface Logger {
  abstract log(
    severity: LogLevel,
    message: string,
  );
}

class ConsoleLogger implements Logger {
  log(
    severity: LogLevel,
    message: string,
  ) {
    console.log(`${severity}: ${message}`);
  }
}
```

To fix this error, remove the `abstract` keyword:

```typescript
interface Logger {
  log(
    severity: LogLevel,
    message: string,
  );
}
```

Alternatively, convert the interface into an abstract class:

```typescript
abstract class Logger {
  abstract log(
    severity: LogLevel,
    message: string,
  );
}

class ConsoleLogger extends Logger {
  log(
    severity: LogLevel,
    message: string,
  ) {
    console.log(`${severity}: ${message}`);
  }
}
```

Introduced in quick-lint-js version 2.10.0.
