# E0296: abstract properties are only allowed in abstract classes

```config-for-examples
{
  "globals": {
    "LogLevel": true
  }
}
```

TypeScript abstract classes can contain abstract methods and fields. It
is a syntax error to write an abstract method or field in a class not marked
`abstract`:

```typescript
class Logger {
  // Implement this in subclasses.
  abstract log(
    severity: LogLevel,
    message: string,
  );
}

class ConsoleLogger extends Logger {
  log(
    severity: LogLevel,
    message: string,
  ) {
    console.log(`${severity}: ${message}`);
  }
}
```

To fix this error, add the `abstract` keyword to the class:

```typescript
abstract class Logger {
  // Implement this in subclasses.
  abstract log(
    severity: LogLevel,
    message: string,
  );
}
```

Alternatively, make the method non-abstract by removing the `abstract` keyword
and giving it a body:

```typescript
abstract class Logger {
  // Optionally implement this in subclasses.
  log(
    severity: LogLevel,
    message: string,
  ) {
    // Default behavior: do not log.
  }
}
```

Introduced in quick-lint-js version 2.10.0.
