# E0276: newline is not allowed after 'namespace'

In TypeScript, the `namespace` keyword must be followed by the namespace's name.
It is a syntax error to write a newline between `namespace` and the following
name:

```typescript
namespace
  reallyLongNamespaceName {
  export class Error {}
}
```

To fix this error, put the namespace's name on the same line as the `namespace`
keyword:

```typescript
namespace reallyLongNamespaceName {
  export class Error {}
}
```

Introduced in quick-lint-js version 2.8.0.
