# E0273: TypeScript namespaces are not allowed in JavaScript

TypeScript supports namespaces to describe objects. JavaScript does not support
this syntax. It is a syntax error to use TypeScript's `namespace` keyword to
create a namespace in JavaScript:

```javascript
namespace goog {
  export class Chart {
    // ...
  }
}
```

To fix this error, create a variable with an object instead:

```javascript
const goog = {};

goog.Chart = class Chart {
  // ...
};
```

Introduced in quick-lint-js version 2.8.0.
