# E0264: expected at least one parameter in generic parameter list

```config-for-examples
{
  "globals": {
    "APIResult": true,
    "T": true
  }
}
```

In a TypeScript generic class, function, or type alias, the generic parameter
list is a comma-separated list of variables surrounded by `<` and `>`. It is a
syntax error for the parameter list to be empty:

```typescript
function api<>(endpoint: string): APIResult {
  // ...
}

function flattenArray<>(arrays: T[][]): T[] {
  // ...
}
```

To fix this error, remove `<` and `>`:

```typescript
function api(endpoint: string): APIResult {
  // ...
}
```

Alternatively, write a type variable name inside the brackets:

```typescript
function flattenArray<T>(arrays: T[][]): T[] {
  // ...
}
```

Introduced in quick-lint-js version 2.8.0.
