# E0263: only one comma is allowed between or after generic parameters

```config-for-examples
{
  "globals": {
    "HashMap": true,
    "DefaultHasher": true
  }
}
```

In a TypeScript generic class, function, or type alias, the generic parameter
list is a comma-separated list of variables surrounded by `<` and `>`. It is a
syntax error for the parameter list to have doubled commas:

```typescript
class HashMap<Key, , Hasher> {
  // ...
}

function makeHashMap<Key,, Value>(
): HashMap<Key, Value, DefaultHasher> {
  return new HashMap(new DefaultHasher());
}
```

To fix this error, write a type variable name between the commas:

```typescript
class HashMap<Key, Value, Hasher> {
  // ...
}
```

Alternatively, remove the extra comma:

```typescript
function makeHashMap<Key, Value>(
): HashMap<Key, Value, DefaultHasher> {
  return new HashMap(new DefaultHasher());
}
```

Introduced in quick-lint-js version 2.8.0.
