# E0262: leading commas are not allowed in generic parameter lists

In a TypeScript generic class, function, or type alias, the generic parameter
list is a comma-separated list of variables surrounded by `<` and `>`. It is a
syntax error for the parameter list to start with an extra comma:

```typescript
class MagicMap<
    , Key
    , Value
    > {
  // ...
}
```

To fix this error, remove the leading `,`:

```typescript
class MagicMap
    < Key
    , Value
    > {
  // ...
}
```

Introduced in quick-lint-js version 2.8.0.
