# E0248: extra ',' is not allowed between enum members

In a TypeScript enum, members are separated with commas. It is a syntax error to
write more than one comma between enum members:

```typescript
enum LogLevel {
  DEBUG,,
  ,
  WARNING,
  ERROR,
}
```

To fix this error, remove the extra commas:

```typescript
enum LogLevel {
  DEBUG,
  WARNING,
  ERROR,
}
```

Introduced in quick-lint-js version 2.7.0.
