# E0235: missing quotes around module name

Module names are strings. It is a syntax error to import a module without
enclosing the module name in quotation marks:

```javascript
import React from react;
import { readFile } from fs;
```

To fix this error, add quotation marks around the module's name:

```javascript
import React from "react";
import { readFile } from 'fs';
```

Introduced in quick-lint-js version 2.6.0.
