# E0224: TypeScript type annotations are not allowed in JavaScript code

JavaScript variables and function returns cannot be explicitly typed with an
annotation:

```javascript
async function fetchJSON(uri: string): Promise<any> {
  let req: Response = await fetch(uri);
  return await req.json();
}
```

To fix this error, rename your file to have a `.ts` or `.tsx` suffix.

Alternatively, use JSDoc to write the annotations:

```typescript
/**
 * @param {string} uri
 * @returns {Promise<any>}
 */
async function fetchJSON(uri) {
  /** @type {Response} */
  let req = await fetch(uri);
  return await req.json();
}
```

Introduced in quick-lint-js version 2.6.0.
