# E0223: missing semicolon after field

Class fields and TypeScript interface fields must end with either a semicolon
(`;`) or a newline. It is a syntax error to omit the semicolon and write
something on the same line after the field:

```javascript
class Potato {
  sprouts = []  age = 0
}
```

To fix this error, write `;` to separate the fields:

```javascript
class Potato {
  sprouts = []; age = 0;
}
```

Alternatively, put the fields on separate lines:

```javascript
class Potato {
  sprouts = []
  age = 0
}
```

Introduced in quick-lint-js version 2.6.0.
