# E0212: integer cannot be represented and will be rounded

JavaScript stores integers as 64-bit floating-point numbers. Integers outside
this range will lose precision:

```javascript
const kilo  = 1_000;
const mega  = 1_000_000;
const giga  = 1_000_000_000;
const tera  = 1_000_000_000_000;
const peta  = 1_000_000_000_000_000;
const exa   = 1_000_000_000_000_000_000;
const zetta = 1_000_000_000_000_000_000_000;
// yotta is equal to 999999999999999983222784
const yotta = 1_000_000_000_000_000_000_000_000;
```

To fix this error, use a BigInt instead of a Number:

```javascript
const kilo  = 1_000n;
const mega  = 1_000_000n;
const giga  = 1_000_000_000n;
const tera  = 1_000_000_000_000n;
const peta  = 1_000_000_000_000_000n;
const exa   = 1_000_000_000_000_000_000n
const zetta = 1_000_000_000_000_000_000_000n;
const yotta = 1_000_000_000_000_000_000_000_000n;
```

Introduced in quick-lint-js version 2.5.0.
