# E0210: unopened block comment

```config-for-examples
{
  "globals": {
    "heightInCM": true,
    "debugPrint": true,
    "state": true
  }
}
```

Block comments start with `/*` and end with `*/`. It is a syntax error for a
block comment to end but not start:

```javascript-ignoring-extra-errors
//
// this code is really complicated.
// some might say too complicated.
*/
function yes() {
  return true;
}

/*
console.log("[debug] state:");
debugPrint(state, /*depth=*/3);
*/

let heightInFeet = heightInCM */ 3.28;
```

To fix this error, remove the `*/`:

```javascript
//
// this code is really complicated.
// some might say too complicated.
function yes() {
  return true;
}
```

Alternatively, use `//` or `if (false)` to avoid nesting block comments:

```javascript
if (false) {
  console.log("[debug] state:");
  debugPrint(state, /*depth=*/3);
}
```

Alternatively, write an expression between `*` and `/`:

```javascript
let heightInFeet = heightInCM * 100 / 3.28;
```

Introduced in quick-lint-js version 0.4.0.
