# E0184: missing 'if' after 'else'

In an `if`-`else if`-`else` chain, it is a syntax error to omit the `if` keyword
after `else`:

```javascript
function lastName(name) {
  let parts = name.split();
  if (parts.length === 2) {
    return parts[1];
  } else (parts.length === 1) {
    return name;
  } else {
    throw new Error(`unexpected name: ${name}`);
  }
}
```

To fix this error, write `if` between `else` and the condition:

```javascript
function lastName(name) {
  let parts = name.split();
  if (parts.length === 2) {
    return parts[1];
  } else if (parts.length === 1) {
    return name;
  } else {
    throw new Error(`unexpected name: ${name}`);
  }
}
```

Introduced in quick-lint-js version 2.0.0.
