# E0171: "globals" descriptor must be a boolean or an object

In a [quick-lint-js configuration file][], each entry in `"globals"`
must be a boolean or a descriptor object. It is an error if a `"globals"` item
is an array, a number, a string, or `null`:

```quick-lint-js.config
{
    "globals": {
        "gsap": "true"
    }
}
```

To fix this error, make the `"globals"` entry `true` or `false`:

```quick-lint-js.config
{
    "globals": {
        "gsap": true
    }
}
```

[quick-lint-js configuration file]: https://quick-lint-js.com/config/

Introduced in quick-lint-js version 0.4.0.
