# E0152: legacy octal literals may not contain underscores

A legacy octal literal is a `0` digit followed by one or more octal digits (`0`
through `7`). It is a syntax error for a legacy octal literal to contain a digit
separator (`_`):

```javascript
let fileMode = 01_755;
```

To fix this error, begin the literal with `0o`:

```javascript
let fileMode = 0o1_755;
```

Alternatively, remove the underscore:

```javascript
let fileMode = 01755;
```

Introduced in quick-lint-js version 0.2.0.
