# E0136: cannot update variable with '+=' while declaring it

```config-for-examples
{
  "globals": {
    "x": true,
    "y": true,
    "z": true
  }
}
```

When declaring a variable with `const`, `let`, or `var`, you can set the
variable's initial value using `=`. It is a syntax error to use a compound
assignment operator instead of `=`:

```javascript
let i = 0;
while (i < 100) {
  let i += 1;
  console.log(i % 15 ? i : "FizzBuzz");
}

const length *= Math.sqrt(x*x + y*y + z*z);
```

To fix this error, remove the `let` keyword:

```javascript
let i = 0;
while (i < 100) {
  i += 1;
  console.log(i % 15 ? i : "FizzBuzz");
}
```

Alternatively, replace the compound assignment operator with `=`:

```javascript
const length = Math.sqrt(x*x + y*y + z*z);
```

Introduced in quick-lint-js version 0.2.0.
