# E0127: TypeScript's 'enum' feature is not allowed in JavaScript

JavaScript does not support TypeScript-style enums. It is a syntax error to
declare an enum:

```javascript
enum Color {
  BLUE,
  GREEN,
  RED,
}

const favoriteColor = Color.BLUE;
```

To fix this error, write an object instead:

```javascript
const Color = {
  BLUE: 0,
  GREEN: 1,
  RED: 2,
};

const favoriteColor = Color.BLUE;
```

Alternatively, declare separate variables:

```javascript
const Color_BLUE = 0;
const Color_GREEN = 1;
const Color_RED = 2;

const favoriteColor = Color_BLUE;
```

Introduced in quick-lint-js version 0.2.0.
