# E0116: unexpected 'default' outside switch statement

`switch` statements can contain a `default` label. It is a syntax error to write
a `default` label outside a `switch` statement:

```javascript
function colorToHexCode(color) {
  switch (color) {
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
    default:
      throw new Error(`unknown color ${color}`);
}
```

To fix this error, move the `default` label into a `switch` statement:

```javascript
function colorToHexCode(color) {
  switch (color) {
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
    default:
      throw new Error(`unknown color ${color}`);
  }
}
```

Introduced in quick-lint-js version 0.2.0.
