# E0113: incomplete export; expected 'export default ...' or 'export {name}' or 'export * from ...' or 'export class' or 'export function' or 'export let'

```config-for-examples
{
  "globals": {
    "Benchmark": true,
    "registerBenchmark": true
  }
}
```

It is a syntax error to write the `export` keyword without anything following:

```javascript
class SmallBenchmark extends Benchmark {}
export {SmallBenchmark};
class BigBenchmark extends Benchmark {}
export
```

To fix this error, complete the `export` statement:

```javascript
class SmallBenchmark extends Benchmark {}
export {SmallBenchmark};
class BigBenchmark extends Benchmark {}
export {BigBenchmark};
```

Introduced in quick-lint-js version 0.2.0.
