# E0107: expected '{'

A `switch` statement has a list of cases. It is a syntax error to omit `{` after
the condition of a `switch` statement:

```javascript
function colorToHexCode(color) {
  switch (color)
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}
```

To fix this error insert a `{` after the condition:

```javascript
function colorToHexCode(color) {
  switch (color) {
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}
```

Introduced in quick-lint-js version 0.2.0.
