# E0077: function call before declaration in blocked scope

A function can't be called before its declaration in block scope in some
JavaScript engines (including the engines used in Google Chrome and Mozilla
Firefox):

```javascript
f();
{
    function f() {}
}
```

To fix this error, move the function call below the block scope in which it is declared:

```javascript
{
    function f() {}
}
f();
```

Another way to fix this error, move the function out of the block scope in which it is declared.

```javascript
f();
function f() {}
{
}
```
    
OR

```javascript
f();
{
}
function f() {}
```

Introduced in quick-lint-js version 0.3.0.
