# E0060: invalid hex escape sequence

```config-for-examples
{
  "globals": {
    "isBlue": true
  }
}
```

String literals and template literals can contain escape sequences, including
`\x` followed by two hexadecimal digits. It is an error for `\x` to be followed
by anything except two hexadecimal digits:

```javascript
let gameTitle = isBlue
  ? 'Pok\xmon Blue'
  : 'Pok\xe9mon Red';

let path = 'c:\xampp\bin\apache.exe';
```

To fix this error, complete the sequence by writing two hexadecimal digits:

```javascript
let gameTitle = isBlue
  ? 'Pok\xe9mon Blue'
  : 'Pok\xe9mon Red';
```

Alternatively, escape `\` with an extra `\`:

```javascript
let path = 'c:\\xampp\\bin\\apache.exe';
```

Introduced in quick-lint-js version 0.2.0.
