# E0057: use of undeclared variable

```config-for-examples
{
  "globals": {
    "isHappy": true
  }
}
```

It is an error to use a function or variable without declaring it:

```javascript
consol.write("Hello, world!");
const one = Math.sin(pi/2);

function encrypt() {
  return data ^ 0x13371337;
}

if (isHappy) {
  let emotion = "happy";
} else {
  let emotion = "sad";
}
console.log("I am " + emotion);

function MyComponent({}) {
  let [pressed, setPressed] = useState(false);
}

google.charts.load('current', {
  packages: ['corechart'],
});
```

To fix this error, fix the name of the function or variable:

```javascript
console.write("Hello, world!");
const one = Math.sin(Math.pi/2);
```

Alternatively, declare the function or variable:

```javascript
function encrypt(data) {
  return data ^ 0x13371337;
}
```

Alternatively, move the declaration of the variable into an outer scope:

```javascript
let emotion;
if (isHappy) {
  emotion = "happy";
} else {
  emotion = "sad";
}
console.log("I am " + emotion);
```

Alternatively, import the function or variable:

```javascript
import { useState } from "react";
function MyComponent({}) {
  let [pressed, setPressed] = useState(false);
}
```

Alternatively, if the function or variable is global in your environment, [write
a quick-lint-js.config file](https://quick-lint-js.com/config/).

Introduced in quick-lint-js version 0.2.0.
