# E0053: missing property name between '.' and '.'

```config-for-examples
{
  "globals": {
    "me": true
  }
}
```

The `.` operator accesses an object's property. It is a syntax error to write
two `.` in a row without a property name in between:

```javascript
console.log(`My bestie is ${me..name}`);

let favoriteLanguage = 'Lua';
console.log('I love ' .. favoriteLanguage .. '!');
```

To fix this error, write the property name between the two `.`s:

```javascript
console.log(`My bestie is ${me.bestFriend.name}`);
```

Alternatively, concatenate strings using `+` instead of `..`:

```javascript
let favoriteLanguage = 'Lua';
console.log('I love ' + favoriteLanguage + '!');
```

Introduced in quick-lint-js version 0.2.0.
