# E0024: const/let/var with no bindings

`const`, `let`, or `var` statements need to declare at least one variable. It is
an error to declare nothing:

```javascript
var
const friends = ["strager"];
for (let  of friends) {
}
```

To fix this error, add a variable name:

```javascript
var bestFriend;
const friends = ["strager"];
for (let friend of friends) {
  bestFriend = friend;
}
```

Introduced in quick-lint-js version 0.2.0.
