# E0014: expected expression before newline

`throw` statements cannot have a newline between the `throw` keyword and the
thrown expression:

```javascript
throw
  new Error(
    "something terrible happened!"
  );
```

To fix this error, add parentheses:

```javascript
throw (
  new Error(
    "something terrible happened!"
  )
);
```

Alternatively, start the expression on the same line as the `throw` keyword:

```javascript
throw new Error(
  "something terrible happened!"
);
```


Introduced in quick-lint-js version 0.2.0.
