# E0345: using equality or inequality operators against an object literal always produces the same result


Using equality or inequality operators against any object literal will always yield false or true respectively, e.g. 

```javascript
const cat = {
  name: 'Morris',
  sex: 'Male',
};

// the expression inside the if statement is always 'false'
if (cat === { name: 'Morris', sex: 'Male' }) { 
}

// the expression inside the if statement is always 'true'
if (cat !== { name: 'Morris', sex: 'Male' }) { 
}
```

To fix this particular example, we could compare the properties manually

```javascript
const cat = {
  name: 'Morris',
  sex: 'Male',
};

if (cat.name === 'Morris' && cat.sex === 'Male') {
}
```

Introduced in quick-lint-js version 2.10.0.
