# E0278: TypeScript type exports are not allowed in JavaScript

TypeScript supports exporting types using `export type`. It is a syntax error to
write `export type` in JavaScript code:

```javascript
// Warning: Do not instantiate directly.
// Use makeBanana instead.
class Banana {
}
// Don't allow instantiating Bananas directly.
export type {Banana};

/** @returns {Banana} */
export function makeBanana() {
  return new Banana();
}
```

To fix this error, export the variable normally by removing the `type` keyword:

```javascript
// Warning: Do not instantiate directly.
// Use makeBanana instead.
class Banana {
}
export {Banana};
```

Introduced in quick-lint-js version 2.8.0.
