# E0258: missing type between '|' and '|' (or '&' and '&')

An extra `|` or `&` is allowed at the beginning of a TypeScript type. However,
it is a syntax error to write an extra `|` or `&` in the middle of a TypeScript
type:

```typescript
type Primitive =
  | string
  | number
  | bigint
  | boolean
  | null |
  | undefined
```

To fix this error, remove the extra `|` or `&`:

```typescript
type Primitive =
  | string
  | number
  | bigint
  | boolean
  | null
  | undefined
```

Introduced in quick-lint-js version 2.7.0.
